/**
 * @namespace desknet's NEO系アプリ共通処理
 */
var app = {};

/**
 * @namespace desknet's NEO系アプリ: 言語別リソース
 */
app.Resource = {
    "loadingText": "読み込み中…",
    "processingLabel": "処理中…",
    "rootLabel": "ルート",
    "choosenItemCountLabel": "{{count}}件選択中",

    "gender_male": "男性",
    "gender_female": "女性",
    "userLevel_admin": "システム管理者",
    "public_on": "公開",
    "public_off": "非公開",

    "hours": "{{num}}時間",
    "days": "{{num}}日",

    // 日時形式
    "listDateFormat": "yyyy/MM/dd", // 一覧用日付形式
    "listDateFormat_yearless": "MM/dd", // 一覧用日付形式(年省略)
    "listDateTimeFormat": "yyyy/MM/dd HH:mm", // 一覧用日時形式
    "listDateTimeFormat_yearless": "MM/dd HH:mm", // 一覧用日時形式(年省略)
    "detailDateFormat": "yyyy年M月d日(E)", // 参照/設定用日付形式
    "detailDateTimeFormat": "yyyy年M月d日(E) HH:mm", // 参照/設定用日時形式
    "calendarDateFormat": "yyyy年M月d日(E)", // カレンダー用日付形式
    "calendarDateFormat_yearless": "M月d日(E)", // カレンダー用日付形式(年省略)
    "yearFormat": "yyyy年", // 年形式
    "monthFormat": "yyyy年M月", // 年月形式
    "monthOnlyFormat": "M月", // 月形式
    "monthAndDayFormat": "M月d日", // 月日形式
    "timeFormat": "HH:mm", // 時間形式

    "timeAmpm": "none" // 時間のAM/PMの位置
}

/**
 * フォーム文言
 */
app.Resource.form = {
    "invalidMissingMessage": "この項目は必須です。",
    "invalidEmailMismatchMessage": "メールアドレスの書式が正しくありません。",
    "invalidUrlMismatchMessage": "URLの書式が正しくありません。",
    "invalidNumberMismatchMessage": "数値が正しくありません。",
    "invalidNumberUnderflowMessage": "{{value}}以上の数値を入力してください。",
    "invalidNumberOverflowMessage": "{{value}}以下の数値を入力してください。",
    "invalidDateMismatchMessage": "日付が正しくありません。",
    "invalidDateUnderflowMessage": "{{value}}以後の日付を入力してください。",
    "invalidDateOverflowMessage": "{{value}}以前の日付を入力してください。",
    "invalidImportFileMessage": "インポートするファイルを選択してください。"
}

/**
 * ダイアログ文言
 */
app.Resource.dialog = {
    "errorTitle": "エラー",
    "warnTitle": "警告",
    "messageTitle": "情報",
    "addOkButtonLabel": "追加", // 追加ダイアログの肯定ボタン
    "createOkButtonLabel": "作成", // 作成ダイアログの肯定ボタン
    "updateOkButtonLabel": "変更", // 変更ダイアログの肯定ボタン
    "startToUpdateOkButtonLabel": "編集", // 変更ダイアログを開くボタン
    "saveButtonLabel": "下書き保存" // 作成、変更ダイアログの下書きボタン
}

/**
 * レイアウト
 */
app.Resource.layout = {
    "openTitle": "開く",
    "closeTitle": "閉じる",
    "floatTitle": "固定しないで開く",
    "resizeWidthTitle": "幅を変更",
    "resizeHeightTitle": "高さを変更"
}

/**
 * ページ
 */
app.Resource.page = {
    "groupName_allUsers": "(すべてのユーザー)",
    "groupName_notInGroup": "(組織に属さない)",
    "groupName_disused": "(利用停止中)",
    "groupName_locked": "(ログイン拒否中)",
    "groupName_deleted": "(削除済み)",
    "detailSearchTitle": "詳細検索",
    "detailSearchSearchButton": "検索",
    "detailSearchClearButton": "クリア"
}

/**
 * 選択
 */
app.Resource.chooser = {
    "itemChooserTitle": "選択",
    "groupChooserTitle": "組織選択",
    "userChooserTitle": "ユーザー選択",
    "groupName_all": "(すべて)",
    "groupName_allUser": "(すべてのユーザー)",
    "groupName_notInGroup": "(組織に属さない)",
    "chooseTarget_user": "ユーザー",
    "chooseTarget_group": "組織",
    "tabHeaderLabel_search": "検索",
    "tabHeaderLabel_group": "組織別",
    "tabHeaderLabel_history": "履歴",
    "history_linkLabel": "{{type}}を表示"
}

/**
 * アップロード
 */
app.Resource.uploader = {
    "uploadingTitle": "アップロード中...", // アップロード中ダイアログのタイトル
    "chooseButtonLabel": neo.Resource.dialog.actionOkButtonLabel, // アップロードの決定ボタン(選択のみ)
    "uploadButtonLabel": "アップロード", // アップロードの決定ボタン(すぐ送信)
    "abortButtonLabel": "中止" // アップロードの中止ボタン
}

/**
 * カレンダー用
 */
app.Resource.calendar = {
    "glue": "、",
    "allDay": "終日",
    "termWithEndDate": "{{start_date:hs}}～{{end_date:hs}}",
    "termWithRepeat": "{{start_date:hs}}から{{repeat_times:hs}}回繰り返す",
    "interval_d": "{{interval:hs}}日ごと",
    "interval_d_every": "毎日",
    "interval_w": "{{interval:hs}}週間ごと {{days_of_week:hs}}",
    "interval_w_every": "毎週 {{days_of_week:hs}}",
    "interval_m": "{{interval:hs}}ヶ月ごと {{day_of_month:hs}}",
    "interval_m_every": "毎月 {{day_of_month:hs}}",
    "interval_y": "{{interval:hs}}年ごと",
    "interval_y_every": "毎年",
    "dayOfMonthWithDay": "{{day:hs}}日",
    "dayOfMonthWithWeekAndDay": "{{week:hs}}{{day_of_week:hs}}",
    "weeksOfMonth": ["最終", "第1", "第2", "第3", "第4"],
    "RecurrenceEditorTitle": "定期的な予定",
    "DateChooserTitle": "不定期な予定",
    "monthCalendarHeader": ["日","月","火","水","木","金","土"], // 短い週の名前(日曜日から)、全角1文字まで
}

/**
 * ログイン
 */
app.Resource.sign = {
    "modifyPasswordTitle": "パスワードの変更",
    "entryLicenseTitle": "ライセンス設定"
}

/**
 * UI Datepickerのオプション
 */
app.Resource.datepickerOptions = {
    "dateFormat": "yy/mm/dd",
    "nextText": "次へ",
    "prevText": "前へ",
    "currentText": "今日",
    "closeText": "閉じる",
    "yearSuffix": "年",
    "showMonthAfterYear": true,
    "dayNamesMin": app.Resource.calendar.monthCalendarHeader, // 曜日名(カレンダー用、全角1文字まで)
    "monthNames": neo.Resource.dateTime.longMonthes, // 月名(省略),
    "monthNamesShort": neo.Resource.dateTime.shortMonthes // 月名(省略)
}

/**
 * メッセージ
 */
app.Resource.Message = {
    "pageBeforeUnload": "入力されたデータは保存されていません。",
    "pageBeforeNavigate": "このページから移動すると入力していた内容が失われます。\n移動してよろしいですか？",
    "dialogBeforeClose": "ダイアログを閉じると入力していた内容が失われます。\n閉じてよろしいですか？",

    "listConfirmToDelete": "選択したデータを削除してよろしいですか？",
    "listTargetRequired": "対象を選択してください。",
    "listSortableItemsRequired": "移動対象を選択してください。",
    "listConfirmToMove": "選択した位置に移動してよろしいですか。",
    "listDeleteItemsRequired": "削除対象を選択してください。",

    "inputConfirmToDelete": "削除してよろしいですか。",

    "uploadNameDuplicated": "ファイル「{{name}}」は既に存在します。置き換えますか？",
    "uploadIgnoreNonImage": "GIF、JPEG、PNGのいずれかのファイルのみ選択できます。\nそれ以外のファイルが選択されませんでした。",
    "uploadIgnoreNonImage_single": "GIF、JPEG、PNGのいずれかのファイルを選択してください。",
    "uploadIgnoreSizeOver": "サイズが{{size}}以下のファイルのみ選択できます。\nそれ以外のファイルが選択されませんでした。",
    "uploadFileSizeOver": "アップロード可能なファイルサイズを超えています。<br>実際のファイルサイズ({{total}})／ファイルサイズの上限({{max}})",

    "calendarDatesRequired": "日付を選択してください。",

    "passwordTrialRest": "あと{{count}}回間違えるとログインできなくなります。",

    "importExecutionTitle": "インポート中",
    "importUnderExecution": "しばらくお待ちください。",
    "importComplete": "インポートが完了しました。",

    "treeConfirmToMove": "選択した{{count:hs}}件を移動してよろしいですか？<br>移動先：{{name}}",

    "licenseDueMessage": "{{due}}まで(あと{{date}}日)使用可能です。",
    "evaluateLicenseMessage": "御利用ありがとうございます。ご使用のモジュールは試使用版として提供されています。<br />",
    "expiredLicenseMessage": "使用期限を過ぎています。続けてご利用いただく場合、『ライセンスキー』をご購入ください。",
    "entryLicenseMessage": "ご購入いただきました『ライセンスキー』は<a href=\"#\" class=\"app-license-entry\">こちら</a>から追加できます。",
    "exceedanceLicenseMessage": "{{count}} ユーザーライセンスが不足しています。",
    "exceedanceNoExpireLicenseMessage": "{{limit}}日以内に{{count}}ユーザーを削除するか、または、不足しているライセンスをご購入ください。",
    "exceedanceExpireLicenseMessage": "不足しているライセンスをご購入ください。",
    "availableLicenseMessage": "{{count}} ユーザーライセンス購入済み"
}
